{ ********************************************************************************** }
{                                                                                    }
{ 	 COPYRIGHT 1997 Kevin Boylan                                                    }
{     Source File: Unzip.pas                                                         }
{     Description: VCLUnZip component demo - native Delphi unzip component.          }
{     Date:        March 1997                                                        }
{     Author:      Kevin Boylan, CIS: boylank                                        }
{                                Internet: boylank@compuserve.com                    }
{                                                                                    }
{ ********************************************************************************** }
unit Unzip;
{$P-}
interface

uses
{$IFDEF WIN32}
  Windows, ComCtrls,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  SysUtils, Messages, ShellAPI, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons,
	Menus, Gauges, IncZip, Tabnotbk, IniFiles, OvrWrite, VCLUnZip, KPLib;

type
  TVCLUnZipForm = class(TForm)
    Panel1: TPanel;
    ExtractBtn: TSpeedButton;
    OpenZipBtn: TSpeedButton;
    StatusBar: TPanel;
    Header1: THeader;
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Action1: TMenuItem;
    Unzip1: TMenuItem;
    Sort1: TMenuItem;
    None1: TMenuItem;
    FileName1: TMenuItem;
    Dircetory1: TMenuItem;
    Date1: TMenuItem;
    Size1: TMenuItem;
    Rate1: TMenuItem;
    NoOrder: TMenuItem;
    UncompressedSize1: TMenuItem;
    Gauge1: TGauge;
    CurrentFileLabel: TLabel;
    Infowin: TMemo;
    Gauge2: TGauge;
    Label2: TLabel;
    ZipCommentMnu: TMenuItem;
    UnZipper: TVCLUnZip;
    Options: TTabbedNotebook;
    UseDirInfoChk: TCheckBox;
    Label4: TLabel;
    OverwriteCombo: TComboBox;
    Label1: TLabel;
    EnterPassword: TEdit;
    WildCardList: TEdit;
    Label3: TLabel;
    OnStartUnZipInfoChk: TCheckBox;
    OnStartUnZipChk: TCheckBox;
    OnBadCRCChk: TCheckBox;
    OnBadPasswordChk: TCheckBox;
    OnSkippingFileChk: TCheckBox;
    SpeedButton1: TSpeedButton;
    FilesList: TListBox;
    ClearLogWindow1: TMenuItem;
    DefaultViewer: TEdit;
    Label5: TLabel;
    DefViewerSelect: TButton;
    FileSelectDlg: TOpenDialog;
    ForceDefaultViewer: TCheckBox;
    LowerCaseFiles: TCheckBox;
    Help1: TMenuItem;
    About1: TMenuItem;
    RenameDlg: TSaveDialog;
    procedure ExtractBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OpenZipBtnClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure OnSort(Sender: TObject);
    procedure Header1Sized(Sender: TObject; ASection, AWidth: Integer);
	  procedure UnZipperStartUnZip(Sender: TObject; FileIndex: Integer; FName: String);
    procedure UnZipperBadPassword(Sender: TObject; FileIndex: Integer);
    procedure UnZipperFilePercentDone(Sender: TObject; Percent: Longint);
    procedure UnZipperSkippingFile(Sender: TObject; Reason: TSkipReason; FileIndex: Integer);
    procedure UnZipperPromptForOverwrite(Sender: TObject; var OverWriteIt: Boolean;
	  					FileIndex: Integer; var FName: String);
    procedure UnZipperBadCRC(Sender: TObject; CalcCRC, StoredCRC: LongInt; FileIndex: Integer);
    procedure UnZipperTotalPercentDone(Sender: TObject; Percent: Longint);
    procedure ZipCommentMnuClick(Sender: TObject);
    procedure UnZipperStartUnzipInfo(Sender: TObject; NumFiles: Integer;
      TotalBytes: Longint; var StopNow: Boolean);
    procedure UseDirInfoChkClick(Sender: TObject);
    procedure OverwriteComboChange(Sender: TObject);
    procedure OnLoggingClick(Sender: TObject);
    procedure UnZipperGetNextDisk(Sender: TObject; NextDisk: Integer);
    procedure FilesList1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FilesList1MeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure UnZipperInCompleteZip(Sender: TObject;
      var IncompleteMode: TIncompleteZipMode);
    procedure ClearLogWindow1Click(Sender: TObject);
    procedure FilesListDblClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DefViewerSelectClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
	private
    { Private declarations }
    procedure OpenTheZip;
    procedure InitHeaderWidths;
    procedure CleanupViewList;
    procedure ReadIni;
    procedure WriteIni;
  public
    { Public declarations }
end;

var
  VCLUnZipForm: TVCLUnZipForm;
  CheckedSortItem: TMenuItem;
  ViewFilesList: TStringList;
  ZipFromDir: String;

implementation

{$R *.DFM}

function CRate( uc, c: LongInt ): LongInt; forward;

procedure TVCLUnZipForm.FormCreate(Sender: TObject);
var
  CommandLine:   String;
  ArgPos:        Integer;
begin
  ReadIni;
  InitHeaderWidths;
  CheckedSortItem := NoOrder;
  CheckedSortItem.Checked := True;
  UseDirInfoChk.Checked := False;
  OverwriteCombo.ItemIndex := 0;
  UseDirInfoChk.Checked := UnZipper.RecreateDirs;
  OverwriteCombo.ItemIndex := Ord(UnZipper.OverwriteMode);
	ViewFilesList := TStringList.Create;
  { WIN32 includes module path\filename in cmdline }
	CommandLine := StrPas(CmdLine);
{$IFDEF WIN32}
	ArgPos := Pos(' ',CommandLine);
	If (ArgPos = 0) or (ArgPos = Length(CommandLine)) then
		CommandLine := ''
	Else
		CommandLine := Copy( CommandLine, ArgPos+1, Length(CommandLine) );
{$ENDIF}
	If (CommandLine = '') or (not (File_Exists(CommandLine))) then
		  UnZipper.ZipName := ZipFromDir + '\dummy.zip' { just to seed the initial directory for }
  Else                                              { the open zip dialog box                }
   begin
		UnZipper.ZipName := CommandLine;
     OpenTheZip;
   end;
end;

procedure TVCLUnZipForm.ExtractBtnClick(Sender: TObject);
var
  PName, FName: String;
  i: Integer;
begin
   If UnZipper.Count = 0 then
    begin
		MessageBeep(0);
		exit;
    end;
   With UnZipper do
    begin
     try
        DestDir := '?';
     except
        On EUserCanceled do
           exit;
        else
           raise;
     end;
     If DestDir <> '?' then
      begin
      	Password := EnterPassword.Text;
        if (VCLUnZipForm.FilesList.SelCount = 0) and (WildCardList.Text = '') then
         begin
           DoAll := True;
           UnZip;
         end
        else
         begin
           DoAll := False;
           UnZipper.FilesList.Clear;
           For i := 0 to VCLUnZipForm.FilesList.Items.Count-1 do
              If VCLUnZipForm.FilesList.Selected[i] then
               begin
                 PName := Pathname[i];
                 FName := Filename[i];
                 UnZipper.FilesList.Add( Pathname[i] + Filename[i] );
               end;
           If WildCardList.Text <> '' then
           	UnZipper.FilesList.Add( WildCardList.Text );
           UnZip;
         end;
      end;
    end;
    Gauge1.Progress := 0;
    Gauge2.Progress := 0;
    CurrentFileLabel.Caption := '';
    MessageBeep(0);
end;

procedure TVCLUnZipForm.OpenZipBtnClick(Sender: TObject);
begin
	try
		UnZipper.ZipName := '?';
	except
		On EUserCanceled do
			exit;
		Else
     	raise;    { If not EUserCanceled the re-raise the exception }
	end;
	OpenTheZip;
end;

procedure TVCLUnZipForm.OpenTheZip;
begin
  If UnZipper.ZipName <> '?' then
  begin
     CleanupViewList;
     UnZipper.ReadZip;
     FilesList.Items.BeginUpdate;
     UnZipper.FillList( FilesList.Items );
     FilesList.Items.EndUpdate;
     StatusBar.Caption := IntToStr(UnZipper.Count) + ' Files';
     ZipCommentMnu.Checked := UnZipper.ZipHasComment;
     Caption := UnZipper.ZipName;
     ZipFromDir := ExtractFilePath(UnZipper.ZipName);
  end;
end;

procedure TVCLUnZipForm.InitHeaderWidths;
begin
  With Header1 do
  begin
     SectionWidth[0] := Canvas.TextWidth('XXXXXXXX.XXXX'); { File }
     SectionWidth[1] := Canvas.TextWidth('XX/XX/XXX');     { Date }
     SectionWidth[2] := Canvas.TextWidth('99:99PMX');      { Time }
     SectionWidth[3] := Canvas.TextWidth('99999999');      { Size }
     SectionWidth[4] := Canvas.TextWidth('99999999');      { Packed }
     SectionWidth[5] := Canvas.TextWidth('XXXXx');          { Rate }
     SectionWidth[6] := Canvas.TextWidth('XXXXXX');        { Method }
     SectionWidth[7] := Canvas.TextWidth('XXXXXXXXXXXXXX');{ Path }
  end;
end;

procedure TVCLUnZipForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TVCLUnZipForm.ReadIni;
var
  IniFile: TIniFile;
begin
  IniFile := TIniFile.Create('VCLZip.Ini');
  DefaultViewer.Text := IniFile.ReadString('Viewer','Default','');
  ForceDefaultViewer.Checked := IniFile.ReadBool('Viewer','Force',False);
  UnZipper.DestDir := IniFile.ReadString('Paths','DestDir','c:\');
	ZipFromDir := IniFile.ReadString('Paths','FromDir','c:\');
	If (Length(ZipFromDir) > 0) and (ZipFromDir[Length(ZipFromDir)] = '\') then
		SetLength(ZipFromDir,Length(ZipFromDir)-1);
  IniFile.Free;
end;

procedure TVCLUnZipForm.WriteIni;
var
  IniFile: TIniFile;
begin
  IniFile := TIniFile.Create('VCLZip.Ini');
  IniFile.WriteString('Viewer','Default',DefaultViewer.Text);
  IniFile.WriteBool('Viewer','Force',ForceDefaultViewer.Checked);
  { Just to be sure, we don't want dialog boxes to come up if user has this app
    associated with zip files and double clicks on a zip file in File Manager or
    Explorer }
  If UnZipper.DestDir = '?' then
     UnZipper.DestDir := 'C:\';
  If ZipFromDir = '?' then
		ZipFromDir := 'C:';
	If ZipFromDir[Length(ZipFromDir)] = '\' then
		SetLength(ZipFromDir,Length(ZipFromDir)-1);
	IniFile.WriteString('Paths','DestDir',UnZipper.DestDir);
  IniFile.WriteString('Paths','FromDir',ZipFromDir);
  IniFile.Free;
end;

procedure TVCLUnZipForm.CleanupViewList;
var
  i: Integer;
begin
  If ViewFilesList.Count > 0 then
   begin
     For i := 0 to ViewFilesList.Count-1 do
			SysUtils.DeleteFile(ViewFilesList[i]);
     ViewFilesList.Clear;
   end;
end;

procedure TVCLUnZipForm.Close1Click(Sender: TObject);
begin
  FilesList.Clear;
  UnZipper.ClearZip;
  CleanupViewList;
  Caption := 'VCLUnZip Utility';
end;

procedure TVCLUnZipForm.OnSort(Sender: TObject);
begin
  With Sender as TMenuItem do
  begin
     UnZipper.Sort( TZipSortMode(Tag) );
     UnZipper.FillList( FilesList.Items );
     Checked := True;
     CheckedSortItem.Checked := False;
  end;
  CheckedSortItem := TMenuItem(Sender);
end;

procedure TVCLUnZipForm.Header1Sized(Sender: TObject; ASection,
  AWidth: Integer);
begin
  FilesList.Refresh;
end;

procedure TVCLUnZipForm.UnZipperStartUnZip(Sender: TObject; FileIndex: Integer; FName: String);
begin
	With UnZipper do
	 begin
		Infowin.Lines.Add( 'Unzipping ' + FName + '. Method -> ' +
  						  CompressMethodStr[FileIndex] );
     CurrentFileLabel.Caption := Filename[FileIndex];
   end;
end;

procedure TVCLUnZipForm.UnZipperBadPassword(Sender: TObject; FileIndex: Integer);
var
	MsgArray: array[0..300] of char;
begin
	With UnZipper do
	 begin
		StrPCopy( MsgArray, 'Invalid Password for file ' + Filename[FileIndex]);
		Application.MessageBox( MsgArray, 'Password Error', mb_OK );
  	InfoWin.Lines.Add( '...Invalid password for file ' + Filename[FileIndex] );
   end;
end;

procedure TVCLUnZipForm.UnZipperFilePercentDone(Sender: TObject;
  Percent: Longint);
begin
	Gauge1.Progress := Percent;
end;

procedure TVCLUnZipForm.UnZipperSkippingFile(Sender: TObject; Reason: TSkipReason;
														 FileIndex: Integer);
var
	theReason: String;
begin
	if Reason = srBadPassword then
  	theReason := 'Bad Password'
  else
  	theReason := 'Avoid Overwrite';
     
	With UnZipper do
		InfoWin.Lines.Add( '...Skipping file ' + Filename[FileIndex] + '. Reason: ' + theReason );
end;

procedure TVCLUnZipForm.UnZipperPromptForOverwrite(Sender: TObject;
		var OverWriteIt: Boolean; FileIndex: Integer; var FName: String);
var
	AllDone: Boolean;
begin
	AllDone := True;
	With UnZipper do
	 Repeat
		OverwriteDlg.FName.Caption := FName;
		OverwriteDlg.ShowModal;
		If OverwriteDlg.Action = oaOverwrite then
			OverwriteIt := True
		Else If OverwriteDlg.Action = oaSkip then
			OverwriteIt := False;
		If OverwriteDlg.Action = oaRename then
			With RenameDlg do
			 begin
				AllDone := False;
				InitialDir := ExtractFilePath(FName);
				FileName := ExtractFilename(FName);
				If RenameDlg.Execute then
				 begin
					FName := FileName;
					OverWriteIt := True;
					AllDone := True;
				 end;
			 end;
	 Until AllDone;
end;

procedure TVCLUnZipForm.UnZipperBadCRC(Sender: TObject;
	CalcCRC, StoredCRC: LongInt; FileIndex: Integer);
var
	MsgArray: array [0..300] of char;
begin
	With UnZipper do
	 begin
		StrPCopy( MsgArray, 'Bad CRC for file ' + Filename[FileIndex] );
		Application.MessageBox( MsgArray, 'CRC Error', mb_OK );
  	InfoWin.Lines.Add( '...Bad CRC for file ' + Filename[FileIndex] );
  	InfoWin.Lines.Add( '......Stored CRC is     ' + IntToStr(StoredCRC) );
  	InfoWin.Lines.Add( '......Calculated CRC is ' + IntToStr(CalcCRC) );
   end;
end;

procedure TVCLUnZipForm.UnZipperTotalPercentDone(Sender: TObject;
  Percent: Longint);
begin
	Gauge2.Progress := Percent;
end;

procedure TVCLUnZipForm.ZipCommentMnuClick(Sender: TObject);
begin
	If ZipCommentMnu.Checked then
   begin
		InfoWin.Lines.Add( ' ' );
     InfoWin.Lines.Add( UnZipper.ZipComment );
   end;
end;

procedure TVCLUnZipForm.UnZipperStartUnzipInfo(Sender: TObject;
  NumFiles: Integer; TotalBytes: Longint; var StopNow: Boolean);
begin
	InfoWin.Lines.Add( ' ' );
	InfoWin.Lines.Add( 'Number of files to be extracted: ' + IntToStr(NumFiles) );
	InfoWin.Lines.Add( 'Total bytes of output: ' + IntToStr(TotalBytes) );
	InfoWin.Lines.Add( 'Files unzipping to: ' + Unzipper.DestDir );
end;

procedure TVCLUnZipForm.UseDirInfoChkClick(Sender: TObject);
begin
  UnZipper.RecreateDirs := UseDirInfoChk.Checked;
end;

procedure TVCLUnZipForm.OverwriteComboChange(Sender: TObject);
begin
  UnZipper.OverwriteMode := TUZOverwriteMode(OverwriteCombo.ItemIndex);
end;

procedure TVCLUnZipForm.OnLoggingClick(Sender: TObject);
var
  theTag: LongInt;
begin
  With (Sender as TCheckBox) do
  begin
     theTag := Tag;
     With UnZipper do
        Case Checked of
           True:
              Case theTag of
                 0: OnStartUnZipInfo := UnZipperStartUnzipInfo;
                 1: OnStartUnZip := UnZipperStartUnZip;
                 2: OnBadCRC := UnZipperBadCRC;
                 3: OnBadPassword := UnZipperBadPassword;
                 4: OnSkippingFile := UnZipperSkippingFile;
              end;
           False:
              Case theTag of
                 0: OnStartUnZipInfo := nil;
                 1: OnStartUnZip := nil;
                 2: OnBadCRC := nil;
                 3: OnBadPassword := nil;
                 4: OnSkippingFile := nil;
              end;
        end;
  end;
end;

procedure TVCLUnZipForm.UnZipperGetNextDisk(Sender: TObject;
  NextDisk: Integer);
var
  MsgArray: array [0..100] of Char;
begin
  StrPCopy( MsgArray, 'Please insert disk ' + IntToStr(NextDisk) + ' of the multi-disk set.' );
  Application.MessageBox(MsgArray, 'Multi-Disk Zip File', mb_OK);
end;

procedure TVCLUnZipForm.FilesList1DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  r: TRect;
  x: Integer;
  FName: String;
  ZipTimeStr: String;
  ZipDateStr: String;
  zSize, zPacked, zRate: String;
const
  M = 4;  { Margin }
begin
 If Index > UnZipper.Count-1 then
  exit;
 With (Control as TListBox) do
  With UnZipper do
   begin
     r := Rect;

     { Filename }
     FName := Filename[Index];
     If LowerCaseFiles.Checked then
        FName := LowerCase(FName);
     If IsEncrypted[Index] then
        FName := FName + '#';
     r.Right := r.Left + Header1.SectionWidth[0];
     x := r.Left + M;
     Canvas.TextRect(r, x, r.Top, FName);

     { Date and Time }
     ZipDateStr := Format( '%8s', [FormatDateTime( 'mm/dd/yy', DateTime[Index] )] );
     ZipTimeStr := Format( '%7s', [FormatDateTime( 'hh:mmam/pm', DateTime[Index] )] );

     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[1];
     x := r.Left + (r.Right - r.Left) - Canvas.TextWidth(ZipDateStr)-M ;
     Canvas.TextRect(r, x, r.Top, ZipDateStr);

     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[2];
     x := r.Left + (r.Right - r.Left) - Canvas.TextWidth(ZipTimeStr) - M;
     Canvas.TextRect(r, x, r.Top, ZipTimeStr);

     { Size }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[3];
     zSize := Format('%8d',[UnCompressedSize[Index]]);
     x := r.Left + (r.Right - r.Left) - Canvas.TextWidth(zSize) - M;
     Canvas.TextRect(r, x, r.Top, zSize);

     { Packed }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[4];
     zPacked := Format('%8d',[CompressedSize[Index]]);
     x := r.Left + (r.Right - r.Left) - Canvas.TextWidth(zPacked) - M;
     Canvas.TextRect(r, x, r.Top, zPacked);

     { Rate }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[5];
     zRate := Format('%3d%s',[CRate(UnCompressedSize[Index],CompressedSize[Index]),'%']);
     x := r.Left + (r.Right - r.Left) - Canvas.TextWidth(zRate) - M;
     Canvas.TextRect(r, x, r.Top, zRate);

     { Method }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[6];
     x := r.Left + M;
     Canvas.TextRect(r, x, r.Top, CompressMethodStr[Index]);

     { Path }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[7];
     x := r.Left + M;
     Canvas.TextRect(r, x, r.Top, Pathname[Index]);

     { Disk # }
     r.Left := r.Right;
     r.Right := r.Left + Header1.SectionWidth[8];
     x := r.Left + M;
     Canvas.TextRect(r, x, r.Top, IntToStr(DiskNo[Index]));

   end;
end;

function CRate( uc, c: LongInt ): LongInt;
var
  R: Real;
begin
  If uc > 0 then
     R := ((uc-c)*100)/uc
  else
     R := 0;
  Result := Round(R);
end;

procedure TVCLUnZipForm.FilesList1MeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
begin
  Height := (Control as TListBox).Canvas.TextHeight('W');
end;

procedure TVCLUnZipForm.UnZipperInCompleteZip(Sender: TObject;
  var IncompleteMode: TIncompleteZipMode);
var
  IncZipDlg: TIncompleteZipDlg;
begin
  IncZipDlg := TIncompleteZipDlg.Create(Self);
  If (IncZipDlg.ShowModal = IDOK) then
     IncompleteMode := izAssumeBad
  Else
     IncompleteMode := izAssumeMulti;
  IncZipDlg.Release;
end;

procedure TVCLUnZipForm.ClearLogWindow1Click(Sender: TObject);
begin
  InfoWin.Clear;
end;

procedure TVCLUnZipForm.FilesListDblClick(Sender: TObject);
var
  ViewFilePStr: array [0..PATH_LEN] of char;
  ViewFile: String;
  tempPathPStr: array [0..PATH_LEN] of char;
  tempPath: String;
  savePath: String;
  PathSize: LongInt;
  ExecStat: Integer;
  Msg: array [0..255] of char;
begin
  PathSize := GetTempPath( SizeOf(tempPathPStr), @tempPathPStr[0] );
  tempPath := StrPas(tempPathPStr);
  ViewFile := UnZipper.Filename[FilesList.ItemIndex];
  StrPCopy( PChar(@ViewFilePStr[0]), ViewFile );
  UnZipper.FilesList.Clear;
  UnZipper.FilesList.Add( ViewFile );
  savePath := UnZipper.DestDir;
  UnZipper.DestDir := tempPath;
  If ViewFilesList.IndexOf( tempPath + ViewFile ) = -1 then
     If (UnZipper.UnZip > 0) then
        ViewFilesList.Add( tempPath + ViewFile );
  UnZipper.DestDir := savePath;
	If File_Exists(tempPath+ViewFile) then
   begin
     ExecStat := 32;
     If not ForceDefaultViewer.Checked then
        THandle(ExecStat) := ShellExecute( Handle,Nil,ViewFilePStr,Nil,tempPathPStr,SW_SHOWNORMAL);
     If (ExecStat < 32) or (ForceDefaultViewer.Checked) then
      begin
        StrPCopy( Msg, DefaultViewer.Text + ' ' + tempPath + ViewFile );
        ExecStat := WinExec( Msg, SW_SHOWNORMAL );
      end;
     If ExecStat < 32 then
        ShowMessage( 'Couldn''t view file' );
     Gauge1.Progress := 0;
     Gauge2.Progress := 0;
     CurrentFileLabel.Caption := '';
   end
  Else
     ShowMessage('Couldn''t UnZip the file');
end;

procedure TVCLUnZipForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  WriteIni;
  CleanupViewList;
  ViewFilesList.Free;
end;

procedure TVCLUnZipForm.DefViewerSelectClick(Sender: TObject);
begin
  If (FileSelectDlg.Execute) then
   begin
     DefaultViewer.Text := FileSelectDlg.Filename;
   end;
end;

procedure TVCLUnZipForm.About1Click(Sender: TObject);
begin
	ShowMessage( 'VCLUnZip Demo, Copyright 1997 Kevin L. Boylan, KpGb Software' );
end;


end.
